#version 330
#extension GL_EXT_gpu_shader4 : enable
//Pacific OceanMod01.fsh  by  pajunen
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define HOSEK_RAD_X if (index < 3) { if (index < 1) { return 1.471043; } else { if (index < 2) { return 1.746088; } else { return -0.929970; } } } else { if (index < 4) { return 17.203620; } else { if (index < 5) { return 5.473384; } else { return 8.336416; } } }
#define HOSEK_RAD_Y if (index < 3) { if (index < 1) { return 1.522034; } else { if (index < 2) { return 1.844545; } else { return -1.322862; } } } else { if (index < 4) { return 19.183820; } else { if (index < 5) { return 5.440769; } else { return 8.837119; } } }
#define HOSEK_RAD_Z if (index < 3) { if (index < 1) { return 1.107408; } else { if (index < 2) { return 2.382765; } else { return -5.112357; } } } else { if (index < 4) { return 21.478230; } else { if (index < 5) { return 14.931280; } else { return 14.608820; } } }
#define HOSEK_COEFF_X if (index < 27) { if (index < 13) { if (index < 6) { if (index < 3) { if (index < 1) { return -1.129483; } else { if (index < 2) { return -1.146420; } else { return -1.128348; } } } else { if (index < 4) { return -1.025820; } else { if (index < 5) { return -1.083957; } else { return -1.062465; } } } } else { if (index < 9) { if (index < 7) { return -0.189062; } else { if (index < 8) { return -0.188358; } else { return -0.264130; } } } else { if (index < 11) { if (index < 10) { return 0.014047; } else { return -0.260668; } } else { if (index < 12) { return -0.151219; } else { return -9.065101; } } } } } else { if (index < 20) { if (index < 16) { if (index < 14) { return 3.309173; } else { if (index < 15) { return 1.223176; } else { return -1.187406; } } } else { if (index < 18) { if (index < 17) { return 2.207108; } else { return 1.042881; } } else { if (index < 19) { return 9.659923; } else { return -3.127882; } } } } else { if (index < 23) { if (index < 21) { return 0.055150; } else { if (index < 22) { return 2.729900; } else { return -7.202803; } } } else { if (index < 25) { if (index < 24) { return 14.278390; } else { return -0.036078; } } else { if (index < 26) { return -0.069382; } else { return -0.349065; } } } } } } else { if (index < 40) { if (index < 33) { if (index < 30) { if (index < 28) { return 0.587759; } else { if (index < 29) { return -5.968103; } else { return -4.242214; } } } else { if (index < 31) { return 0.831436; } else { if (index < 32) { return 0.398711; } else { return 1.997784; } } } } else { if (index < 36) { if (index < 34) { return -0.276114; } else { if (index < 35) { return 2.129455; } else { return 0.403810; } } } else { if (index < 38) { if (index < 37) { return 0.081817; } else { return 0.140058; } } else { if (index < 39) { return -0.041237; } else { return 0.460263; } } } } } else { if (index < 47) { if (index < 43) { if (index < 41) { return -0.077895; } else { if (index < 42) { return 0.199778; } else { return 4.768868; } } } else { if (index < 45) { if (index < 44) { return 6.283042; } else { return -2.251251; } } else { if (index < 46) { return 8.305125; } else { return -1.137688; } } } } else { if (index < 50) { if (index < 48) { return 2.814449; } else { if (index < 49) { return 0.633978; } else { return 0.526708; } } } else { if (index < 52) { if (index < 51) { return 0.948347; } else { return 0.394500; } } else { if (index < 53) { return 0.887177; } else { return 0.580320; } } } } } }
#define HOSEK_COEFF_Y if (index < 27) { if (index < 13) { if (index < 6) { if (index < 3) { if (index < 1) { return -1.144464; } else { if (index < 2) { return -1.170104; } else { return -1.129171; } } } else { if (index < 4) { return -1.042294; } else { if (index < 5) { return -1.082293; } else { return -1.071715; } } } } else { if (index < 9) { if (index < 7) { return -0.204380; } else { if (index < 8) { return -0.211863; } else { return -0.255288; } } } else { if (index < 11) { if (index < 10) { return 0.004450; } else { return -0.272306; } } else { if (index < 12) { return -0.142657; } else { return -10.201880; } } } } } else { if (index < 20) { if (index < 16) { if (index < 14) { return 4.391405; } else { if (index < 15) { return 0.223830; } else { return -0.511603; } } } else { if (index < 18) { if (index < 17) { return 2.065076; } else { return 1.095351; } } else { if (index < 19) { return 10.712470; } else { return -4.198900; } } } } else { if (index < 23) { if (index < 21) { return 0.731429; } else { if (index < 22) { return 2.627589; } else { return -8.143133; } } } else { if (index < 25) { if (index < 24) { return 17.297830; } else { return -0.032567; } } else { if (index < 26) { return -0.071116; } else { return -0.356273; } } } } } } else { if (index < 40) { if (index < 33) { if (index < 30) { if (index < 28) { return 0.609900; } else { if (index < 29) { return -7.892212; } else { return -3.851931; } } } else { if (index < 31) { return 0.786021; } else { if (index < 32) { return 0.389044; } else { return 1.881931; } } } } else { if (index < 36) { if (index < 34) { return -0.126464; } else { if (index < 35) { return 2.142231; } else { return 0.436051; } } } else { if (index < 38) { if (index < 37) { return 0.068727; } else { return 0.102483; } } else { if (index < 39) { return -0.030787; } else { return 0.432528; } } } } } else { if (index < 47) { if (index < 43) { if (index < 41) { return -0.071062; } else { if (index < 42) { return 0.211444; } else { return 4.824771; } } } else { if (index < 45) { if (index < 44) { return 6.282535; } else { return -1.039120; } } else { if (index < 46) { return 7.080503; } else { return -1.122398; } } } } else { if (index < 50) { if (index < 48) { return 2.970832; } else { if (index < 49) { return 0.625984; } else { return 0.536569; } } } else { if (index < 52) { if (index < 51) { return 0.909630; } else { return 0.458365; } } else { if (index < 53) { return 0.833851; } else { return 0.594439; } } } } } }
#define HOSEK_COEFF_Z if (index < 27) { if (index < 13) { if (index < 6) { if (index < 3) { if (index < 1) { return -1.353023; } else { if (index < 2) { return -1.624704; } else { return -0.798361; } } } else { if (index < 4) { return -1.266679; } else { if (index < 5) { return -1.009707; } else { return -1.075646; } } } } else { if (index < 9) { if (index < 7) { return -0.481352; } else { if (index < 8) { return -0.799020; } else { return 0.141748; } } } else { if (index < 11) { if (index < 10) { return -0.428898; } else { return -0.153775; } } else { if (index < 12) { return -0.176875; } else { return -31.049200; } } } } } else { if (index < 20) { if (index < 16) { if (index < 14) { return -21.671250; } else { if (index < 15) { return 9.914841; } else { return -5.818701; } } } else { if (index < 18) { if (index < 17) { return 3.496378; } else { return -1.347762; } } else { if (index < 19) { return 31.401560; } else { return 22.463410; } } } } else { if (index < 23) { if (index < 21) { return -10.815030; } else { if (index < 22) { return 6.986437; } else { return -3.013726; } } } else { if (index < 25) { if (index < 24) { return 1.989004; } else { return -0.009511; } } else { if (index < 26) { return -0.011635; } else { return -0.012188; } } } } } } else { if (index < 40) { if (index < 33) { if (index < 30) { if (index < 28) { return -0.081807; } else { if (index < 29) { return 0.242115; } else { return 0.013758; } } } else { if (index < 31) { return 0.554203; } else { if (index < 32) { return 0.541575; } else { return 0.341139; } } } } else { if (index < 36) { if (index < 34) { return 1.397403; } else { if (index < 35) { return -0.283193; } else { return 1.764810; } } } else { if (index < 38) { if (index < 37) { return 0.008135; } else { return 0.026184; } } else { if (index < 39) { return -0.061377; } else { return 0.201692; } } } } } else { if (index < 47) { if (index < 43) { if (index < 41) { return 0.030034; } else { if (index < 42) { return 0.133002; } else { return 3.136646; } } } else { if (index < 45) { if (index < 44) { return 1.139214; } else { return 7.445848; } } else { if (index < 46) { return -1.275731; } else { return 3.702862; } } } } else { if (index < 50) { if (index < 48) { return 3.230864; } else { if (index < 49) { return 0.521599; } else { return 0.344436; } } } else { if (index < 52) { if (index < 51) { return 1.180080; } else { return 0.259277; } } else { if (index < 53) { return 0.774632; } else { return 0.662621; } } } } } }


// Implementation of 2012 Hosek-Wilkie skylight model

#define M_PI 3.1415926535897932384626433832795
#define M_PI_2 1.57079632679
#define CIE_X 0
#define CIE_Y 1
#define CIE_Z 2

float sample_coeff(int channel, int quintic_coeff, int coeff) {    
    int index =  6 * coeff + quintic_coeff;
    if (channel == CIE_X) {HOSEK_COEFF_X}
    if (channel == CIE_Y) {HOSEK_COEFF_Y}
    if (channel == CIE_Z) {HOSEK_COEFF_Z}
}

float sample_radiance(int channel, int quintic_coeff) {
    int index = quintic_coeff;
    if (channel == CIE_X) {HOSEK_RAD_X}
    if (channel == CIE_Y) {HOSEK_RAD_Y}
    if (channel == CIE_Z) {HOSEK_RAD_Z}
}

float eval_quintic_bezier(in float[6] control_points, float t) {
	float t2 = t * t;
	float t3 = t2 * t;
	float t4 = t3 * t;
	float t5 = t4 * t;
	
	float t_inv = 1.0 - t;
	float t_inv2 = t_inv * t_inv;
	float t_inv3 = t_inv2 * t_inv;
	float t_inv4 = t_inv3 * t_inv;
	float t_inv5 = t_inv4 * t_inv;
		
	return (
		control_points[0] *             t_inv5 +
		control_points[1] *  5.0 * t  * t_inv4 +
		control_points[2] * 10.0 * t2 * t_inv3 +
		control_points[3] * 10.0 * t3 * t_inv2 +
		control_points[4] *  5.0 * t4 * t_inv  +
		control_points[5] *        t5
	);
}

float transform_sun_zenith(float sun_zenith) {
	float elevation = M_PI / 2.0 - sun_zenith;
		return pow(elevation / (M_PI / 2.0), 0.333333);
}

void get_control_points(int channel, int coeff, out float[6] control_points) {
	for (int i = 0; i < 6; ++i) control_points[i] = sample_coeff(channel, i, coeff);
}

void get_control_points_radiance(int channel, out float[6] control_points) {
	for (int i = 0; i < 6; ++i) control_points[i] = sample_radiance(channel, i);
}

void get_coeffs(int channel, float sun_zenith, out float[9] coeffs) {
	float t = transform_sun_zenith(sun_zenith);
	for (int i = 0; i < 9; ++i) {
		float control_points[6]; 
		get_control_points(channel, i, control_points);
		coeffs[i] = eval_quintic_bezier(control_points, t);
	}
}

vec3 mean_spectral_radiance(float sun_zenith) {
	vec3 spectral_radiance;
	for (int i = 0; i < 3; ++i) {
		float control_points[6];
        get_control_points_radiance(i, control_points);
		float t = transform_sun_zenith(sun_zenith);
		spectral_radiance[i] = eval_quintic_bezier(control_points, t);
	}
	return spectral_radiance;
}

float F(float theta, float gamma, in float[9] coeffs) {
	float A = coeffs[0];
	float B = coeffs[1];
	float C = coeffs[2];
	float D = coeffs[3];
	float E = coeffs[4];
	float F = coeffs[5];
	float G = coeffs[6];
	float H = coeffs[8];
	float I = coeffs[7];
	float chi = (1.0 + pow(cos(gamma), 2.0)) / pow(1.0 + H*H - 2.0 * H * cos(gamma), 1.5);
	
	return (
		(1.0 + A * exp(B / (cos(theta) + 0.01))) *
		(C + D * exp(E * gamma) + F * pow(cos(gamma), 2.0) + G * chi + I * sqrt(cos(theta)))
	);
}

vec3 spectral_radiance(float theta, float gamma, float sun_zenith) {
	vec3 XYZ;
	for (int i = 0; i < 3; ++i) {
		float coeffs[9];
		get_coeffs(i, sun_zenith, coeffs);
		XYZ[i] = F(theta, gamma, coeffs);
	}
	return XYZ;
}

// Returns angle between two directions defined by zentih and azimuth angles
float angle(float z1, float a1, float z2, float a2) {
	return acos(
		sin(z1) * cos(a1) * sin(z2) * cos(a2) +
		sin(z1) * sin(a1) * sin(z2) * sin(a2) +
		cos(z1) * cos(z2));
}

// Sky is rendered using Hosek-Wilkie skylight model
vec3 sample_sky(float view_zenith, float view_azimuth, float sun_zenith, float sun_azimuth) {    
	float gamma = angle(view_zenith, view_azimuth, sun_zenith, sun_azimuth);
	float theta = view_zenith;   
   	vec3 mean_sr = mean_spectral_radiance(sun_zenith);
    float sun_angular_radius = M_PI / 360.0; // About 0.5 deg
    
    if (gamma > sun_angular_radius) {
		return spectral_radiance(theta, gamma, sun_zenith) * mean_sr;
    } else {
     	return vec3(100.0,100.0,100.0);
    }
}

// CIE-XYZ to linear RGB
vec3 XYZ_to_RGB(vec3 XYZ) {
	mat3 XYZ_to_linear = mat3(
		 3.24096994, -0.96924364, 0.55630080,
		-1.53738318,  1.8759675, -0.20397696,
		-0.49861076,  0.04155506, 1.05697151
	);
	return XYZ_to_linear * XYZ;
}

// Clamps color between 0 and 1 smoothly
vec3 expose(vec3 color, float exposure) {
	return vec3(2.0) / (vec3(1.0) + exp(-exposure * color)) - vec3(1.0);
}

vec2 to_zenith_azimuth(vec3 v) {
 	float zenith = acos(v.y);
    float azimuth = atan(v.x, v.z);
    return vec2(zenith, azimuth);
}

mat3 rotationX( in float angle ) {
	return mat3(	1.0,		     0,			  0,
			 		  0, 	cos(angle),	-sin(angle),
					  0, 	sin(angle),	 cos(angle));
}

mat3 rotationY( in float angle ) {
	return mat3(	cos(angle),		0,		sin(angle),
			 				0,		1.0,			 0,
					-sin(angle),	0,		cos(angle));
}

mat3 rotationZ( in float angle ) {
	return mat3(	cos(angle),		-sin(angle),	0,
			 		sin(angle),		cos(angle),		0,
							0,				0,		1);
}

vec3 fresnel_schlick(float cosTheta, vec3 F0)
{
    return F0 + (max(vec3(1.0), F0) - F0) * pow(1.0 - cosTheta, 5.0);
}   
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{   
	vec2 uv    = (gl_FragCoord.xy -0.5 * iResolution.xy) / iResolution.y;
	vec2 mouse = (iMouse.xy) / iResolution.y;

	float mouse_angle = atan(mouse.x, mouse.y);

	float pixel_angle = atan(uv.x,uv.y);
	float pixel_distance =  length(uv) * M_PI;
    
    float sun_speed = 0.3;
    
    vec3 sun_dir = vec3(0.,0.,1.) * rotationX(-mod((iTime*sun_speed + 12.5) / 5.0, M_PI)) * rotationZ(0.) * rotationY(M_PI);

    vec2 sun_pos = to_zenith_azimuth(sun_dir);
    
    vec3 sample_point = normalize(vec3(uv.xy, 0.5));
    mat3 rot = rotationY(-mouse.x * M_PI) * rotationX(mouse.y * M_PI / 2.0 + M_PI / 9.0);
	vec3 sample_dir = rot * sample_point;
    
    vec3 fresnel = vec3(1.0);
    if (sample_dir.y < 0.0) {
        // Intersection point with water
        float x0 = tan(acos(sample_dir.y)) / 0.5;
        
        // Generate water surface normal
		float N_theta = ((sin(x0) + 1.) / 2.0) * 0.1 * (1.0 / ((x0*.15)*(x0*.15) + 1.0));
		float N_gamma = iTime + x0;
        float sin_N_theta = sin(N_theta);
        float sin_N_gamma = sin(N_gamma);
        float cos_N_theta = cos(N_theta);
        float cos_N_gamma = cos(N_gamma);
		vec3 N = vec3(sin_N_theta * cos_N_gamma, cos_N_theta, sin_N_theta * sin_N_gamma);
        
        // New sample direction
		sample_dir = reflect(sample_dir, N);
        if (sample_dir.y < 0.0) sample_dir.y *= -1.;

        // Eval fresnel
        float cos_theta = max(dot(N, sample_dir), 0.0);
        fresnel = fresnel_schlick(cos_theta, vec3(0.04));
    }
    
    vec2 view_zenith_azimuth = to_zenith_azimuth(sample_dir);
    
    vec3 XYZ = fresnel * sample_sky(view_zenith_azimuth.x, view_zenith_azimuth.y, sun_pos.x, sun_pos.y);  
	vec3 RGB = XYZ_to_RGB(XYZ);

	vec3 col = expose(RGB, 0.1);
	
	gl_FragColor = vec4(col, 1.0);
}